///////////////////////////////////////////////////////////////////////////////////////////////
//Ship structure code
//Created: 12/17/04
//Last Update: 12/17/04
///////////////////////////////////////////////////////////////////////////////////////////////

function oShip(base_image, mushrooms, ammo)
{
	this.x = 0
	this.y = 0

	this.nx = 0
	this.ny = 0
	
	this.bx = 0
	this.by = 0
	
	this.dir = 0
	
	this.zoom = 1

	this.base_image = base_image
	this.image = base_image
	this.mushrooms = mushrooms
		
	this.old_mushrooms = -1
	
	this.ammo = ammo
	this.current_shot = 0
	
	this.stats = new oShipStats(0, 0, 0, 0, 0)	
	
	this.image = -1
	
	this.image_cache = { } 
	
	this.RegenerateShipData = function RegenerateShipData()
		{
			if (this.old_mushrooms == -1)
				{
					this.old_mushrooms = new Array()
					for (var i = 0; i < this.mushrooms.length; i++)
						this.old_mushrooms[i] = Clone(this.mushrooms[i])
				}
		
			this.CalculateStats()
		
			this.image = GetImage(this.base_image)
			
			this.image_cache = { }
			
			this.image = this.image.createSurface() 
			
			//base.setBlendMode(REPLACE)
			
			//this.image.blitSurface(base,0,0)
			
			for (var i = 0; i < this.mushrooms.length; i++)
				{
						
					var mhp = GetMushroomStats(mushrooms[i]).hp
						
					if (mushrooms[i].hp >= mhp/2 ) 
						Picture = GetImage(GetMushroomTypePicture(this.mushrooms[i].type))			
						
					if (mushrooms[i].hp <= mhp/2 ) 
						Picture = GetImage(GetMushroomTypeDark1Picture(this.mushrooms[i].type))															
						
						
					if (mushrooms[i].hp <= mhp/3 ) 
						Picture = GetImage(GetMushroomTypeDark2Picture(this.mushrooms[i].type))
						

						
					Picture = Picture.createSurface()	
					
					var mx = this.mushrooms[i].x * Picture.width
					var my = this.mushrooms[i].y * Picture.height			
					
					//Picture.setAlpha(Random(100,255))

					/*for (var x = -2; x < 18; x++)
						for (var y = -4; y < 18; y++)
							{

								if (mx+x < 319 && mx+x > 0 && my+y < 239 && my+y > 0)
									{
											c2 = this.image.getPixel(mx+x,
																							 my+y)
										
											if (x >= 0 && x <= 15 && y >= 0 && y <= 15)
												{
													c = Picture.getPixel( x, y)
													//c.alpha = 128
												}
												
												
																						
											c3 = Picture.getPixel( 7+Random(0,5), 7)																			
											
											//c3.alpha = 146
											
											//Abort(c2.red+"-"+c2.green+"-"+c2.blue)
											if (c2.red == 248 && c2.blue == 248 && c2.green == 248)		
												{
													this.image.setPixel(mx+x,
																							my+y,
																							c3)													
												
													if (x >= 0 && x <= 15 && y >= 0 && y <= 15)
														this.image.setPixel(mx+x,
																								my+y,
																								c)
																																	
												}
									}
									
								this.image.blitSurface( Picture,mx,my)									
									
							}*/
					

					this.image.blitSurface( Picture,mx,my)	

				}
				this.image = this.image.createImage()	 
		}
		
	this.CalculateStats = function CalculateStats()
	{
		
		var hp = 0		
		var cannon = 0
		var speed = 0
		var accuracy = 0
		var value = 0
		
		var mstat
		
		for (var i = 0; i < this.mushrooms.length; i++)
			{
				mstat = GetMushroomStats(this.mushrooms[i])
				
				hp += mstat.hp
				cannon += mstat.cannon
				speed += mstat.speed
				accuracy += mstat.accuracy
				value += mstat.value
			}
			
		speed = 1+Math.floor(speed/60)
		accuracy = 1+Math.floor(accuracy/60)
			
		//Abort(hp+'-'+cannon+'-'+speed+'-'+accuracy+'-'+value)	
			
		this.stats = new oShipStats(hp, cannon, speed, accuracy, value)	
	}
		
	this.blitSelf = function blitSelf(x, y, zoom)
		{
			this.GetImageCache(zoom).blit(x, y);
		}
		
	this.GetImageCache = function GetImageCache(zoom)
		{
			if (!(zoom in this.image_cache)) 
			{
				var surf = this.image.createSurface()

				surf.rescale(this.image.width * zoom, this.image.height * zoom)
					
				surf = surf.createImage()	
				
				this.image_cache[zoom] = surf;  
			}
			return this.image_cache[zoom];		
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function oShipStats(hp, cannon, speed, accuracy, value)
{
	this.cannon = cannon
	this.hp = hp
	this.speed = speed
	this.accuracy = accuracy
	this.value = value
}

///////////////////////////////////////////////////////////////////////////////////////////////

function TestShip()
{
	LeaveShop()

	var mush = gPlayer_Ship.mushrooms

	var mush1 = new Array()
	var mush2 = new Array() 
	var mush3 = new Array() 
	var mush4 = new Array()
	
	for (var i = 0; i < mush.length; i++)
		{
			mush1[i] = Clone(mush[i])
			mush1[i].hp = GetMushroomStats(mush[i]).hp
			mush2[i] = Clone(mush[i])
			mush2[i].hp = GetMushroomStats(mush[i]).hp
			mush3[i] = Clone(mush[i])
			mush3[i].hp = GetMushroomStats(mush[i]).hp
			mush4[i] = Clone(mush[i])
			mush4[i].hp = GetMushroomStats(mush[i]).hp
		}

	//var s = new oShip("ship0-2.png", mush1, mush2, 5,5,5,415,5,10)
	var s2 = new oShip("ship0-2.png", mush3, mush4, 5,5,5,415,5,10)
	var s = gPlayer_Ship
	
	s.ammo = mush2
	
	s.RegenerateShipData()
	s2.RegenerateShipData()
	
	StartShipBattle(s,s2, "bg2.png", "fg.png")
	
	/*while(1)
		{
			s.image.zoomBlit(0,0,1)
			FlipScreen();
		}*/
}

///////////////////////////////////////////////////////////////////////////////////////////////